// src/routes/workflow.routes.js
const express = require('express');
const router = express.Router();
const workflowController = require('../controllers/workflowController');
const checkAuth = require('../middleware/authMiddleware');
const upload = require('../middleware/uploadMiddleware'); // لاستخدامه في صورة الإصلاح

router.post('/finish-maintenance', checkAuth, workflowController.finishMaintenance);

// مسار لاعتماد/رفض التقارير (للمشرف والمدير)
router.post('/process', checkAuth, workflowController.processReport);

// مسار لإغلاق ملاحظة (للصيانة) - مع إمكانية رفع صورة
router.post('/close-observation', 
    checkAuth, 
    upload.single('rectifiedImage'), // استقبال صورة واحدة للإصلاح
    workflowController.closeObservation
);

module.exports = router;