// src/models/index.js
const sequelize = require('../config/db.config');
const Sequelize = require('sequelize');

// استيراد الجداول
const User = require('./User');
const Report = require('./Report');
const Observation = require('./Observation');

// تعريف العلاقات (Associations)
// 1. المفتش لديه تقارير
User.hasMany(Report, { foreignKey: 'inspectorId', as: 'reports' });
Report.belongsTo(User, { foreignKey: 'inspectorId', as: 'inspector' });

// 2. التقرير لديه ملاحظات
Report.hasMany(Observation, { foreignKey: 'reportId', as: 'observations' });
Observation.belongsTo(Report, { foreignKey: 'reportId', as: 'report' });

// تجميع كائن قاعدة البيانات
const db = {};
db.Sequelize = Sequelize;
db.sequelize = sequelize;

// إضافة الجداول للكائن
db.User = User;
db.Report = Report;
db.Observation = Observation;

module.exports = db;