// src/middleware/authMiddleware.js
const jwt = require('jsonwebtoken');

module.exports = (req, res, next) => {
    try {
        // 1. جلب التوكن من ترويسة الطلب (Header)
        const token = req.headers.authorization.split(' ')[1]; // Format: "Bearer TOKEN"

        // 2. التحقق من صحة التوكن
        const decodedToken = jwt.verify(token, process.env.JWT_SECRET);

        // 3. إضافة بيانات المستخدم للطلب (ليستخدمها الكنترولر لاحقاً)
        req.userData = { 
            userId: decodedToken.id, 
            role: decodedToken.role 
        };

        next(); // السماح بالمرور
    } catch (error) {
        res.status(401).json({ message: "المصادقة فشلت: يرجى تسجيل الدخول" });
    }
};