// src/controllers/authController.js
const { User } = require('../models');
const bcrypt = require('bcryptjs');
const jwt = require('jsonwebtoken');

// تسجيل مستخدم جديد (سنستخدمه يدوياً لإنشاء المفتشين)
exports.register = async (req, res) => {
    try {
        const { username, fullName, password, role } = req.body;

        // التحقق من وجود المستخدم
        const existingUser = await User.findOne({ where: { username } });
        if (existingUser) return res.status(400).json({ message: "اسم المستخدم موجود مسبقاً" });

        // تشفير كلمة المرور
        const hashedPassword = await bcrypt.hash(password, 10);

        // إنشاء المستخدم
        const user = await User.create({
            username,
            fullName,
            password: hashedPassword,
            role
        });

        res.status(201).json({ message: "تم إنشاء المستخدم بنجاح", userId: user.id });
    } catch (error) {
        res.status(500).json({ message: error.message });
    }
};

// تسجيل الدخول
exports.login = async (req, res) => {
    try {
        const { username, password } = req.body;

        // 1. البحث عن المستخدم
        const user = await User.findOne({ where: { username } });
        if (!user) return res.status(404).json({ message: "اسم المستخدم غير صحيح" });

        // 2. التحقق من كلمة المرور
        const isMatch = await bcrypt.compare(password, user.password);
        if (!isMatch) return res.status(401).json({ message: "كلمة المرور غير صحيحة" });

        // 3. إنشاء التوكن (Token)
        const token = jwt.sign(
            { id: user.id, role: user.role },
            process.env.JWT_SECRET,
            { expiresIn: '24h' } // تنتهي الصلاحية بعد يوم
        );

        res.json({
            message: "تم تسجيل الدخول بنجاح",
            token,
            user: {
                id: user.id,
                username: user.username,
                fullName: user.fullName,
                role: user.role
            }
        });

    } catch (error) {
        res.status(500).json({ message: error.message });
    }
};